#version 330 core

layout (location = 0) in vec3 inPosition;
layout (location = 1) in vec3 inNormal;
layout (location = 2) in vec2 inTexCoords;

out vec3 normal;
out vec3 fragPos;
out vec2 texCoords;

uniform mat4 model;
uniform mat4 camera;
uniform mat4 projection;

void main()
{
	texCoords = inTexCoords;
	fragPos = vec3(model * vec4(inPosition, 1.0));
	normal = mat3(transpose(inverse(model))) * inNormal;
	gl_Position = projection * camera *  model * vec4(inPosition, 1.0);
}
